function [pos,Logbook] = ZoomImage(handles)
% Allows the user to select a region of interest (ROI), which the image is
% cropped to. However, this does just change the displayed image. All data
% is contained and further processed. Thus allowing the user to later
% change the ROI.

global tracer tracer1 tracer2

if isempty(tracer) && isempty(tracer1)
    tracer  = 1;
    tracer2 = 1;
else
    pos     = [];
    Logbook = [];
    clearvars -except pos Logbook
    return
end

%% Load File
image  = load(fullfile(tempdir,'ShowOrg.mat')).image;
image  = image(:,:,1);
SizeX  = size(image,2);
SizeY  = size(image,1);
clearvars image

%% Get Handles
Pos    = get(handles.Zoom,'UserData');                                     % resets prior cropping
Pos2   = [1,1,SizeX,SizeY];
set(handles.Zoom,'UserData',Pos2);

Axes   = get(handles.Load,'UserData');
YScale = SizeY*(Axes(2)/2);
XScale = SizeX*(Axes(1)/2);

Logbook = get(handles.Logbook,'UserData');

%% Calculate
UpdatePlot(handles);                                                       % plots complete image
if all(Pos==Pos2)
    Zoom = drawrectangle(handles.Axis);
    Zoom.UserData.OnCleanup = onCleanup(@()CleanUp);                       % tracks deleted Object
    l = addlistener(Zoom,'ROIClicked',@(src,evt)DoubleClicker(src,evt));
    uiwait;                                                                % Block program execution
    delete(l);                                                             % Remove listener
    try
        pos_rect = Zoom.Position;                                          % Return the current position
    catch
        pos_rect = [-XScale,-YScale,XScale*2,YScale*2];
    end
    delete(Zoom);
else
    pos(1)=  ( Pos(1)-1)*Axes(1)-XScale;                                   % uses the old rectangle position to show old rectangle
    pos(2)= -( Pos(4)-1)*Axes(2)+YScale;                                   % for the user to change to a new positon
    pos(3)=  ( Pos(3)-Pos(1))*Axes(1);
    pos(4)=  ( Pos(4)-Pos(2))*Axes(2);
    Zoom     = drawrectangle(handles.Axis,'Position',pos);
    Zoom.UserData.OnCleanup = onCleanup(@()CleanUp);                       % tracks deleted Object
    l = addlistener(Zoom,'ROIClicked',@(src,evt)DoubleClicker(src,evt));       
    uiwait;                                                                    % Block program execution
    delete(l);                                                                 % Remove listener
    try
        pos_rect = Zoom.Position;                                             % Return the current position
    catch
        pos_rect = [-XScale,-YScale,XScale*2,YScale*2];
    end 
    delete(Zoom);
end
pos_rect(1) = round(( pos_rect(1)+XScale)/Axes(1))+1;                      % translates the selected rectangle position
pos_rect(2) = round((-pos_rect(2)+YScale)/Axes(2))+1;                      % into pixel numbers
pos_rect(3) = round(pos_rect(3)/Axes(1));
pos_rect(4) = round(pos_rect(4)/Axes(2));


%% Check outsiders
% checks wether the user selected a position outside the image. And if so, resets to image boundary.
xmin =  pos_rect(1);
ymin = (pos_rect(2)-pos_rect(4));
xmax = (pos_rect(1)+pos_rect(3));
ymax =  pos_rect(2);


if xmin<1
    xmin     = 1;
end


if ymin<1
    ymin     = 1;
end


if xmax>SizeX
    xmax     = SizeX;
end


if ymax>SizeY
    ymax     = SizeY;
end

if xmin>xmax
    xmin=xmax;
end

if ymin>ymax
    ymin=ymax;
end

pos       = [xmin,ymin,xmax,ymax]; 

%% Update Logbook
Logbook{2}=[ 'ZoomVal: [ ',num2str(xmin),' , ', num2str(ymin),' , ',num2str(xmax),' , ',num2str(ymax),' ]'];

DenLog        = load(fullfile(tempdir,'DenLog.mat')).DenLog;
if ~isempty(DenLog)
DenLog{2}=[ 'ZoomVal: [ ',num2str(xmin),' , ', num2str(ymin),' , ',num2str(xmax),' , ',num2str(ymax),' ]'];
save(fullfile(tempdir,'DenLog.mat'),'DenLog');
end

DeconvLog        = load(fullfile(tempdir,'DeconvLog.mat')).DeconvLog;
if ~isempty(DeconvLog)
DeconvLog{2}=[ 'ZoomVal: [ ',num2str(xmin),' , ', num2str(ymin),' , ',num2str(xmax),' , ',num2str(ymax),' ]'];
save(fullfile(tempdir,'DeconvLog.mat'),'DeconvLog');
end

DecSubLog        = load(fullfile(tempdir,'DeconvLog.mat')).DeconvLog;
if ~isempty(DecSubLog)
DecSubLog{2}=[ 'ZoomVal: [ ',num2str(xmin),' , ', num2str(ymin),' , ',num2str(xmax),' , ',num2str(ymax),' ]'];
save(fullfile(tempdir,'DecSubLog.mat'),'DecSubLog');
end

clearvars -except pos Logbook
end